<?php

/**
* Add menu meta box
*
* @param object $object The meta box object
* @link https://developer.wordpress.org/reference/functions/add_meta_box/
*/
function custom_add_menu_meta_box( $object ) {
    add_meta_box( 'custom-menu-metabox', __( 'Network Sites' ), 'custom_menu_meta_box', 'nav-menus', 'side', 'default' );
    return $object;
}
add_filter( 'nav_menu_meta_box_object', 'custom_add_menu_meta_box', 10, 1);


/**
* Displays a metabox for a network site menu item.
*
* @global int|string $nav_menu_selected_id (id, name or slug) of the currently-selected menu
*/
function custom_menu_meta_box(){
    global $nav_menu_selected_id;
    $walker = new Walker_Nav_Menu_Checklist();

    // Get all sites except corporate
    $sites = get_sites([
        'site__not_in' => [PRIMARY_SITE],
    ]);

    foreach ($sites as &$site) {

        $site->classes = array();
        $site->type = 'network_site';
        $site->title = get_blog_details( array( 'blog_id' => $site->blog_id ) )->blogname;
        $site->object = 'custom';
        $site->object_id = $site->blog_id;
        $site->url = get_site_url( $site->blog_id );
        $site->attr_title = get_blog_details( array( 'blog_id' => $site->blog_id ) )->blogname;

    }

    $removed_args = array( 'action', 'customlink-tab', 'edit-menu-item', 'menu-item', 'page-tab', '_wpnonce' );

    ?>

    <div id="network_sitesarchive" class="categorydiv">

        <div id="tabs-panel-network_sitesarchive-all" class="tabs-panel tabs-panel-view-all tabs-panel-active">
            <ul id="network_sitesarchive-checklist-all" class="categorychecklist form-no-clear">
                <?php
                echo walk_nav_menu_tree( array_map('wp_setup_nav_menu_item', $sites), 0, (object) array( 'walker' => $walker) );
                ?>
            </ul>
        </div>

        <p class="button-controls wp-clearfix">
            <span class="list-controls">
                <a href="<?php echo esc_url( add_query_arg( array( 'network_sitesarchive-tab' => 'all', 'selectall' => 1, ), remove_query_arg( $removed_args ) )); ?>#network_sitesarchive" class="select-all"><?php _e('Select All'); ?></a>
            </span>
            <span class="add-to-menu">
                <input type="submit"<?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> class="button-secondary submit-add-to-menu right" value="<?php esc_attr_e('Add to Menu'); ?>" name="add-network_sitesarchive-menu-item" id="submit-network_sitesarchive" />
                <span class="spinner"></span>
            </span>
        </p>

    </div>

    <?php
}

/**
* Change item label and url depending on the type
*/
function customize_menu_item_label_( $menu_item ) {

    // if is of type network_site, generate url and type_label based on object_id
    if ( 'network_site' == $menu_item->type ) {
        $menu_item->url = get_site_url( $menu_item->object_id );

        $menu_item->type_label = __( 'Network Site', 'menu-item-types' );
    }

    return $menu_item;
}

add_filter( 'wp_setup_nav_menu_item', 'customize_menu_item_label_' );

//
//
//

function get_sub_services()
{
    // Get all sites except corporate
    $sites = get_sites([
        'site__not_in' => [PRIMARY_SITE],
    ]);

    foreach ($sites as $site) {
        switch_to_blog( $site->blog_id );

        // WP_Query arguments
        $args = array(
            'post_type'              => array( 'service' ),
            'posts_per_page'         => '-1',
            'orderby'				   => 'ASC'
        );

        // The Query
        $products = new WP_Query( $args );

        // The Loop
        if ( $products->have_posts() ) {
            while ( $products->have_posts() ) {
                $products->the_post();

                if ( get_field('site_colour', 'options') == '') {
                    $microSiteColour = "#11A0DC";
                } else {
                    $microSiteColour = get_field('site_colour', 'options');
                }
                ?>

                <style type="text/css">
                    .tick:before {
                        background: <?= $microSiteColour; ?>
                    }
                </style>

                <div class="column small-10 medium-6 large-4 home--services-column">
                    <div class="home--services-card">
                        <div class="home--services-card-image">
                            <?php
                            $thumb_id = get_post_thumbnail_id(get_the_id());
                            $thumb_url_array = wp_get_attachment_image_src($thumb_id, 'service_card_thumb', true);
                            $service_card_thumb = $thumb_url_array[0];
                            $image_alt = get_post_meta( $thumb_id, '_wp_attachment_image_alt', true);
                            ?>
                            <img src="<?= $service_card_thumb; ?>" alt="<?= $image_alt; ?>">
                        </div>
                        <div class="home--services-card-content green">
                            <h3><?php the_title(); ?></h3>
                            <?php the_excerpt(); ?>
                            <?php if ( get_field('popular_features') != '' ): ?>
                                <h4>Popular Features</h4>
                                <ul>
                                    <?php if( have_rows('popular_features') ): while ( have_rows('popular_features') ) : the_row(); ?>
                                        <li class="tick">
                                            <?php the_sub_field('title'); ?>
                                        </li>
                                    <?php endwhile; else : endif; ?>
                                    </ul>

                                <?php endif; ?>
                                <div class="home--services-card-btn">
                                    <a href="<?php the_permalink(); ?>" class="btn-aw" style="background-color: <?= $microSiteColour; ?>">Learn More</a>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php }
            }

            // Restore original Post Data
            wp_reset_postdata();


            restore_current_blog();
        }
    }
