<?php

/**
* Add menu meta box
*
* @param object $object The meta box object
* @link https://developer.wordpress.org/reference/functions/add_meta_box/
*/
function custom_add_menu_meta_box( $object ) {
    add_meta_box( 'custom-menu-metabox', __( 'Global Pages' ), 'custom_menu_meta_box', 'nav-menus', 'side', 'default' );
    return $object;
}
add_filter( 'nav_menu_meta_box_object', 'custom_add_menu_meta_box', 10, 1);


/**
* Displays a metabox for a network site menu item.
*
* @global int|string $nav_menu_selected_id (id, name or slug) of the currently-selected menu
*/
function custom_menu_meta_box(){
    global $nav_menu_selected_id;
    $walker = new Walker_Nav_Menu_Checklist();

    // Get all sites except corporate
    $pages = get_sites([
    	'site__not_in' => [PRIMARY_SITE],
    ]);

    $origin_id = PRIMARY_SITE;
    switch_to_blog( $origin_id );

    $wp_pages = get_pages();

    $pages = [];

    foreach ($wp_pages as $key => $page) {

        $element = (object) array(
            'classes'               => array(),
            'type'                  => 'global_page',
            'title'                 => $page->post_title,
            'object'                => 'custom',
            'id'                    => $page->ID,
            'db_id'                 => $page->ID,
            'object_id'             => $page->ID,
            'url'                   => get_the_permalink( $page->ID ),
            'attr_title'            => $page->post_title,
            'menu_item_parent'      => null,
            'target'                => null,
            'xfn'                   => null,
        );
        array_push($pages, $element);

    }

    restore_current_blog();


    $removed_args = array( 'action', 'customlink-tab', 'edit-menu-item', 'menu-item', 'page-tab', '_wpnonce' );

    ?>

    <div id="global_pagesarchive" class="categorydiv">

        <div id="tabs-panel-global_pagesarchive-all" class="tabs-panel tabs-panel-view-all tabs-panel-active">
            <ul id="global_pagesarchive-checklist-all" class="categorychecklist form-no-clear">
                <?php
                echo walk_nav_menu_tree( array_map('wp_setup_nav_menu_item', $pages), 0, (object) array( 'walker' => $walker) );
                ?>
            </ul>
        </div>

        <p class="button-controls wp-clearfix">
            <span class="list-controls">
                <a href="<?php echo esc_url( add_query_arg( array( 'global_pagesarchive-tab' => 'all', 'selectall' => 1, ), remove_query_arg( $removed_args ) )); ?>#global_pagesarchive" class="select-all"><?php _e('Select All'); ?></a>
            </span>
            <span class="add-to-menu">
                <input type="submit"<?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> class="button-secondary submit-add-to-menu right" value="<?php esc_attr_e('Add to Menu'); ?>" name="add-global_pagesarchive-menu-item" id="submit-global_pagesarchive" />
                <span class="spinner"></span>
            </span>
        </p>

    </div>

    <?php
}

/**
 * Change item label and url depending on the type
 */
function customize_menu_item_label_page( $menu_item ) {


    // if is of type network_site, generate url and type_label based on object_id
    if ( 'global_page' == $menu_item->type ) {

        $origin_id = PRIMARY_SITE;
        switch_to_blog( $origin_id );

        $menu_item->url = get_the_permalink( $menu_item->object_id );

        $menu_item->type_label = __( 'Global Page', 'menu-item-types' );

        restore_current_blog();
    }

    return $menu_item;
}

add_filter( 'wp_setup_nav_menu_item', 'customize_menu_item_label_page' );
