<?php

wp_delete_comment (1, true);

add_action( 'wp_before_admin_bar_render', 'portfolio_adminbar' );

function portfolio_adminbar() {

    global $wp_admin_bar;



    foreach (get_sites() as $site) {
        if(PRIMARY_SITE != $site->blog_id) {
            $wp_admin_bar->remove_node('blog-' . $site->blog_id . '-n');
        }
        $wp_admin_bar->remove_node('blog-' . $site->blog_id . '-c');
    }

    // remove all items from New Content menu

    $wp_admin_bar->remove_node('updates');
    $wp_admin_bar->remove_node('comments');
    $wp_admin_bar->remove_node('wp-logo');

    if(get_current_blog_id() != PRIMARY_SITE) {

        $wp_admin_bar->remove_node('new-post');

        $all_nodes = $wp_admin_bar->get_nodes();

        $new_content_node = $all_nodes['new-content'];

        $wp_admin_bar->remove_node('new-content');

        $all_nodes['new-content']->href = $all_nodes['new-content']->href . '?post_type=page';

        $wp_admin_bar->add_node($new_content_node);
    }


}

add_action('admin_head', 'hide_avatar_admin_bar');
function hide_avatar_admin_bar() {
    echo '<style>
    #wp-admin-bar-user-info .avatar { display:none !important; }
    #wp-admin-bar-my-account .avatar { display:none !important; }
    #wpadminbar #wp-admin-bar-user-actions > li { margin-left: 16px !important; }
    </style>';
}

// Disable support for comments and trackbacks in post types
function df_disable_comments_post_types_support() {
    $post_types = get_post_types();
    foreach ($post_types as $post_type) {
        if(post_type_supports($post_type, 'comments')) {
            remove_post_type_support($post_type, 'comments');
            remove_post_type_support($post_type, 'trackbacks');
        }
    }
}
add_action('admin_init', 'df_disable_comments_post_types_support');
// Close comments on the front-end
function df_disable_comments_status() {
    return false;
}
add_filter('comments_open', 'df_disable_comments_status', 20, 2);
add_filter('pings_open', 'df_disable_comments_status', 20, 2);
// Hide existing comments
function df_disable_comments_hide_existing_comments($comments) {
    $comments = array();
    return $comments;
}
add_filter('comments_array', 'df_disable_comments_hide_existing_comments', 10, 2);
// Remove comments page in menu
function df_disable_comments_admin_menu() {
    remove_menu_page('edit-comments.php');
}
add_action('admin_menu', 'df_disable_comments_admin_menu');
// Redirect any user trying to access comments page
function df_disable_comments_admin_menu_redirect() {
    global $pagenow;
    if ($pagenow === 'edit-comments.php') {
        wp_redirect(admin_url()); exit;
    }
}
add_action('admin_init', 'df_disable_comments_admin_menu_redirect');
// Remove comments metabox from dashboard
function df_disable_comments_dashboard() {
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');
}
add_action('admin_init', 'df_disable_comments_dashboard');
// Remove comments links from admin bar
function df_disable_comments_admin_bar() {
    if (is_admin_bar_showing()) {
        remove_action('admin_bar_menu', 'wp_admin_bar_comments_menu', 60);
    }
}
add_action('init', 'df_disable_comments_admin_bar');


function remove_dashboard_meta() {
        remove_meta_box( 'dashboard_incoming_links', 'dashboard', 'normal' );
        remove_meta_box( 'dashboard_plugins', 'dashboard', 'normal' );
        remove_meta_box( 'dashboard_primary', 'dashboard', 'side' );
        remove_meta_box( 'dashboard_secondary', 'dashboard', 'normal' );
        remove_meta_box( 'dashboard_quick_press', 'dashboard', 'side' );
        remove_meta_box( 'dashboard_recent_drafts', 'dashboard', 'side' );
        remove_meta_box( 'dashboard_recent_comments', 'dashboard', 'normal' );
        // remove_meta_box( 'dashboard_right_now', 'dashboard', 'normal' );
        remove_meta_box( 'dashboard_activity', 'dashboard', 'normal');//since 3.8
        remove_action('welcome_panel', 'wp_welcome_panel');
}
add_action( 'admin_init', 'remove_dashboard_meta' );

/**
* Change item label and url depending on the type
*/
function customize_menu_item_label( $menu_item ) {

    // if is of type network_site, generate url and type_label based on object_id
    if ( 'network_site' == $menu_item->type ) {
        $menu_item->url = get_site_url( $menu_item->object_id );

        $menu_item->type_label = __( 'Network Site', 'menu-item-types' );
    }

    return $menu_item;
}

add_filter( 'wp_setup_nav_menu_item', 'customize_menu_item_label' );
