<?php
/**
* The Template for displaying product archives, including the main shop page which is a post type archive
*
* This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
*
* HOWEVER, on occasion WooCommerce will need to update template files and you
* (the theme developer) will need to copy the new files to your theme to
* maintain compatibility. We try to do this as little as possible, but it does
* happen. When this occurs the version of the template file will be bumped and
* the readme will list any important changes.
*
* @see https://docs.woocommerce.com/document/template-structure/
* @package WooCommerce/Templates
* @version 3.4.0
*/

defined( 'ABSPATH' ) || exit;

get_header();

echo get_template_part('includes/default--header-shop'); ?>

<section class="home--shop-section section ">
	<div class="row">

		<?php
		/**
		* Hook: woocommerce_archive_description.
		*
		*/
		do_action( 'woocommerce_archive_description' );

		echo '<div class="column small-12">';

		if ( woocommerce_product_loop() ) {

			/**
			* Hook: woocommerce_before_shop_loop.
			*
			*/
			do_action( 'woocommerce_before_shop_loop' );

			woocommerce_product_loop_start(false);


			if ( wc_get_loop_prop( 'total' ) ) { ?>
				<div class="total-products-found column small-12">
					<h1 style="margin: 0;">My Wishlist</h1>
					<p style="margin: 0 0 4rem;"><?= wc_get_loop_prop( 'total' ); ?> Product<?= (wc_get_loop_prop( 'total' ) != 1) ? 's' : ''; ?> on your Wishlist</p>
				</div>
				<?php

				while ( have_posts() ) {
					the_post();

					/**
					* Hook: woocommerce_shop_loop.
					*
					* @hooked WC_Structured_Data::generate_product_data() - 10
					*/
					do_action( 'woocommerce_shop_loop' );

					wc_get_template_part( 'content', 'product' );
				}
			}

			woocommerce_product_loop_end(false);

			/**
			* Hook: woocommerce_after_shop_loop.
			*
			* @hooked woocommerce_pagination - 10
			*/
			echo '<div class="column small-12">';
			do_action( 'woocommerce_after_shop_loop' );
			echo '</div>';
		} else {
			/**
			* Hook: woocommerce_no_products_found.
			*
			* @hooked wc_no_products_found - 10
			*/
			echo '<div class="row">
			<div class="column small-12">';
			do_action( 'woocommerce_no_products_found' );
			echo '</div>
			</div>';
		}

		echo '</div>';

		/**
		* Hook: woocommerce_after_main_content.
		*
		* @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		*/
		do_action( 'woocommerce_after_main_content' ); ?>

	</div>
</section>

<?php get_footer();
