const mix = require('laravel-mix');

mix.sass('src/scss/app.scss', 'dist/css/app.css')
    .js('src/js/app.js', 'dist/js/app.js')
    // .copy(['one.txt', 'two.txt'], 'output/path')
    .copy('node_modules/@fortawesome/fontawesome-pro/webfonts/*', 'dist/fonts')
    .options({
        processCssUrls: false
    })
    .sourceMaps()
    .webpackConfig({
        devtool: 'source-map',
        resolve: {
            modules: [
                path.resolve(__dirname, 'node_modules')
            ]
        }
    })
    .browserSync({
        proxy: 'https://wordpress.site',
        files: [
            'dist/css/app.css',  // Generated .css file
            'dist/js/app.js',    // Generated .js file
            '*.+(html|php)',     // Generic .html and/or .php files
        ]
    });
