<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "container" div.
 *
 * @package FoundationPress
 * @since FoundationPress 1.0.0
 */

?>
<!doctype html>
<html class="no-js" <?php language_attributes(); ?> >
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>

	<header id="masthead" class="site-header" role="banner">
		<div class="row">
			<div class="site-header--menu-toggle column small-12 medium-3 large-0">
				<div data-responsive-toggle="site-navigation" data-hide-for="large">
					<button class="aw-menu-icon" type="button" data-toggle="site-navigation">Menu</button>
				</div>
			</div>
			<div class="site-header--menu column small-12 large-10">
				<nav id="site-navigation" class="main-navigation" role="navigation">
					<?php wp_nav_menu( array(
              'container'         => false,
              'items_wrap'        => '<ul class="dropdown menu main-navigation__menu" data-dropdown-menu data-close-on-click-inside="false" data-click-open="false">%3$s</ul>',
              'theme_location'    => 'main_navigation_menu'
		        	) ); ?>
				</nav>
			</div>
		</div>
	</header>

	<section class="container">
