<?php
/**
 * Plugin Name: WooCommerce PayPal Pro Hosted
 * Plugin URI: https://woocommerce.com/products/woocommerce-gateway-paypal-pro-hosted/
 * Description: Website Payments Pro Hosted Solutions offers merchants a way to securely accept credit and debit card or PayPal payments without capturing or storing card information on their website. Payment information is collected by PayPal using an inline frame.
 * Version: 1.0.22
 * Author: WooCommerce
 * Author URI: https://woocommerce.com/
 * Text Domain: woocommerce-gateway-paypal-pro-hosted
 * Domain Path: /languages
 * WC tested up to: 4.0
 * WC requires at least: 2.6
 * Tested up to: 5.3
 *
 * Copyright 2017 WooCommerce
 *
 * Woo: 575586:ae76d2bd9336c3eb87355a1395ff2201
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Required functions.
 */
if ( ! function_exists( 'woothemes_queue_update' ) ) {
	require_once( 'woo-includes/woo-functions.php' );
}

/**
 * Plugin updates.
 */
woothemes_queue_update( plugin_basename( __FILE__ ), 'ae76d2bd9336c3eb87355a1395ff2201', '575586' );

if ( ! class_exists( 'WC_Paypal_Pro_Hosted' ) ) :

define( 'WC_PAYPAL_PRO_HOSTED_VERSION', '1.0.21' );

/**
 * PayPal Pro Hosted main class.
 */
class WC_Paypal_Pro_Hosted {

	/**
	 * Instance of this class.
	 *
	 * @var object
	 */
	protected static $instance = null;

	/**
	 * Initialize the plugin public actions.
	 */
	private function __construct() {
		// Load plugin text domain
		add_action( 'init', array( $this, 'load_plugin_textdomain' ) );

		// Plugin action links.
		add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'plugin_action_links' ) );

		// Checks with WooCommerce is installed.
		if ( class_exists( 'WC_Payment_Gateway' ) ) {
			$this->includes();

			add_filter( 'woocommerce_payment_gateways', array( $this, 'add_gateway' ) );
		} else {
			add_action( 'admin_notices', array( $this, 'woocommerce_missing_notice' ) );
		}
	}

	/**
	 * Return an instance of this class.
	 *
	 * @return object A single instance of this class.
	 */
	public static function get_instance() {
		// If the single instance hasn't been set, set it now.
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	/**
	 * Load the plugin text domain for translation.
	 */
	public function load_plugin_textdomain() {
		$locale = apply_filters( 'plugin_locale', get_locale(), 'woocommerce-gateway-paypal-pro-hosted' );

		load_textdomain( 'woocommerce-gateway-paypal-pro-hosted', trailingslashit( WP_LANG_DIR ) . 'woocommerce-gateway-paypal-pro-hosted/woocommerce-gateway-paypal-pro-hosted-' . $locale . '.mo' );
		load_plugin_textdomain( 'woocommerce-gateway-paypal-pro-hosted', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	/**
	 * Add useful links in plugin action links.
	 *
	 * @since 1.0.12
	 * @version 1.0.12
	 *
	 * @param  array $links Links.
	 * @return array links.
	 */
	public function plugin_action_links( $links ) {
		$plugin_links = array(
			'<a href="' . esc_url( admin_url( 'admin.php?page=wc-settings&tab=checkout&section=paypal-pro-hosted' ) ) . '">' . esc_html__( 'Settings', 'woocommerce-gateway-paypal-pro-hosted' ) . '</a>',
			'<a href="https://woocommerce.com/my-account/tickets">' . esc_html__( 'Support', 'woocommerce-gateway-paypal-pro-hosted' ) . '</a>',
			'<a href="https://docs.woocommerce.com/document/woocommerce-gateway-paypal-pro-hosted/">' . esc_html__( 'Docs', 'woocommerce-gateway-paypal-pro-hosted' ) . '</a>',
		);
		return array_merge( $plugin_links, $links );
	}

	/**
	 * Includes.
	 */
	private function includes() {
		include_once( dirname( __FILE__ ) . '/includes/class-wc-paypal-pro-hosted-privacy.php' );
		include_once 'includes/class-wc-paypal-pro-hosted-api.php';
		include_once 'includes/class-wc-gateway-paypal-pro-hosted.php';
		include_once 'includes/class-wc-paypal-pro-hosted-capture.php';
	}

	/**
	 * Add the gateway.
	 *
	 * @param  array $methods WooCommerce payment methods.
	 *
	 * @return array          Paypal Pro Hosted gateway.
	 */
	public function add_gateway( $methods ) {
		$methods[] = 'WC_Gateway_Paypal_Pro_Hosted';

		return $methods;
	}

	/**
	 * WooCommerce fallback notice.
	 *
	 * @return string
	 */
	public function woocommerce_missing_notice() {
		echo '<div class="error"><p>' . sprintf( __( 'WooCommerce PayPal Pro Hosted depends on the last version of %s to work!', 'woocommerce-gateway-paypal-pro-hosted' ), '<a href="http://wordpress.org/extend/plugins/woocommerce/">' . __( 'WooCommerce', 'woocommerce-gateway-paypal-pro-hosted' ) . '</a>' ) . '</p></div>';
	}
}

add_action( 'plugins_loaded', array( 'WC_Paypal_Pro_Hosted', 'get_instance' ) );

endif;
